function TestQ(block)
% Level-2 M file S-function for applying Sobel filtering  
% (image edge detection demonstration).
%   Copyright 1990-2004 The MathWorks, Inc.
%   $Revision: 1.1.6.1 $    
  
  setup(block);

%endfunction

function setup(block)
  
  %% Register dialog parameter: edge direction 
  block.NumDialogPrms = 8;
  block.DialogPrmsTunable = {'NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','NonTunable','Tunable'};
 
  %% Register ports
  block.NumInputPorts  = 2;
  block.NumOutputPorts = 4;
  
  %% Setup port properties
  block.SetPreCompInpPortInfoToDynamic;
  %block.SetPreCompOutPortInfoToDynamic;

  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  
  block.InputPort(1).DatatypeID   = 0;
  block.InputPort(1).Complexity   = 'Real';
  block.InputPort(1).SamplingMode = 'Sample';
  %block.InputPort(1).Overwritable = false; % No in-place operation
  
   block.OutputPort(1).DatatypeID   = 0;
   block.OutputPort(1).Complexity   = 'Real';
   block.OutputPort(1).SamplingMode = 'Sample';
   block.OutputPort(1).Dimensions   = 1;
   
   block.OutputPort(2).DatatypeID   = 0;
   block.OutputPort(2).Complexity   = 'Real';
   block.OutputPort(2).SamplingMode = 'Sample';
   block.OutputPort(2).Dimensions   = 1; 

   block.OutputPort(3).DatatypeID   = 0;
   block.OutputPort(3).Complexity   = 'Real';
   block.OutputPort(3).SamplingMode = 'Sample';
   block.OutputPort(3).Dimensions   = 1;

   block.OutputPort(4).DatatypeID   = 0;
   block.OutputPort(4).Complexity   = 'Real';
   block.OutputPort(4).SamplingMode = 'Sample';
   block.OutputPort(4).Dimensions   = 1;

%   
  %% Register block methods (through MATLAB function handles)
%  block.RegBlockMethod('Outputs', @Output);
  %block.RegBlockMethod('WriteRTW',@WriteRTW);

  %% Block runs on TLC in accelerator mode.
 % block.SetAccelRunOnTLC(true);
 block.RegBlockMethod('Outputs', @Output);
%endfunction


  
  function Output(block)
%pause(0.5)
[block.OutputPort(1).Data , block.OutputPort(2).Data , block.OutputPort(3).Data , block.OutputPort(4).Data]= headquent(block.InputPort(1).Data , block.InputPort(2).Data,block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data,block.DialogPrm(5).Data,block.DialogPrm(6).Data,block.DialogPrm(7).Data,block.DialogPrm(7).Data);

%[block.OutputPort(1).Data , block.OutputPort(2).Data , block.OutputPort(3).Data , block.OutputPort(4).Data]= pap(block.DialogPrm(1).Data,block.DialogPrm(2).Data,block.DialogPrm(3).Data,block.DialogPrm(4).Data);


%SendOSCMessage(block.DialogPrm(1).Data, block.DialogPrm(2).Data, block.DialogPrm(3).Data,  block.InputPort(1).Data )
% function [a,b,c,d]= pap(l,m,n,p)
%          
%            a= l(1,1);
% b = m(1,1);
%  c= n(1,1);
% d= p(1,1);


function [sdvisu, sdcog, sdsmcl, sdsmcr] =  headquent(volt,click,Lx,Ly,Lz,pG,tx2,ty2,tz2,swhead)

    if click < 5
    base=mean(volt,2); %Take off the first seconds as noise
    save('base.mat','base'); 
    end
    
  base=1;  
    [nelec,npack]=size(volt)

% Lx = block.DialogPrm(1).Data;
% Ly = block.DialogPrm(2).Data;
% Lz = block.DialogPrm(3).Data;
% pG = block.DialogPrm(4).Data;

          
          
          
scl1=2.4;% scale factors
scl2=4.0; 
swhead=0;
%area 
acog=[2:8 12:18 20:26 30:36 38:44 326:332 336:342 344:350 354:360];
visu=[146:152 156:162 164:170 174:180 182:188 192:198 200:206 210:216 218:224];
smcl=[87:91 95:101 105:109 113:119 123:127];
smcr=[248:253 256:263 266:271 274:281 284:289];


 %if mod(tatou,10)>0
    %load pG;
    %load sphlocations;
    load base;
%     Lx = block.DialogPrm(1).Data;
%     Ly = block.DialogPrm(2).Data;
%     Lz = block.DialogPrm(3).Data;
%     pG = block.DialogPrm(4).Data;
%     base = block.DialogPrm(8).Data;
    
    data=volt-ones(nelec,npack)*mean(mean(volt))-base*ones(1,npack);
    sol=pG*data;
    showme3(Lx,Ly,Lz,sol,swhead,tx2,ty2,tz2); %show the result
    sdvisu=(mean(mean(sol(visu,:)))+scl1)/scl2 % take the mean power
                                                 % and scale the data
    sdcog=(mean(mean(sol(acog,:)))+scl1)/scl2
    sdsmcl=(mean(mean(sol(smcl,:)))+scl1)/scl2
    sdsmcr=(mean(mean(sol(smcr,:)))+scl1)/scl2
    
%     sendmat(remotehost,port,'/visu','f',1,sdvisu);%send the data
%     sendmat(remotehost,port,'/cog','f',1,sdcog);
%     sendmat(remotehost,port,'/smcl','f',1,sdsmcl);
%     sendmat(remotehost,port,'/smcr','f',1,sdsmcr);    
  %else
%     base=mean(volt,2); %Take off the first seconds as noise
%     save('/export/MatCom/EEGproc/base.mat','base');
%   end  

function showme3(x,y,z,data,head,ttx2,tty2,ttz2)
%     tx2 = block.DialogPrm(5).Data;
%     ty2 = block.DialogPrm(6).Data;
%     tz2 = block.DialogPrm(7).Data;
% function showme2(x,y,z,data,head)
% uses Matlab surf function to show the data
% data has to be adapted to correspond to x,y,z position
% x,y,z have been writted using sphreg2.m
% INPUT:
% - x,y,z : (sp+1) x (st+1) matrices with point coordinates
% - data: data to show
% - head: binary value, if 1: show an head contour in the graph
% OUTPUT:
% - a colored figure of the data

[ta tb]=size(x);
st=ta-1;
sp=tb-1;
Colo=zeros(st+1,sp+1);
Colo(:,sp+1)=data(1); % first position of the data corresponds to top point
npt=1;
for i=0:st-1
  for j=0:sp-1
    if j>sp-3 & mod(i+1,2)==0 % two last lines are subsampled
      Colo(i+1,j+1)=Colo(i,j+1);
    else
      npt=npt+1;
      Colo(i+1,j+1)=data(npt);
    end
  end
end
Colo(st+1,:)=Colo(1,:);

%figure;
% head contour
if head
  load headcontour;
 plot3(ttx2,tty2,ttz2);
 hold on
end

surf(x,y,z,Colo);
%caxis([-12 16]);
shading interp
view(-90,90)
%end %showme3


